<?php

require_once "../../../controladores/cobros.controlador.php";
require_once "../../../modelos/cobros.modelo.php";

require_once "../../../controladores/personas.controlador.php";
require_once "../../../modelos/personas.modelo.php";

require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";

require_once "../../../controladores/plantilla.controlador.php";
require_once "../../../modelos/configuracion.modelo.php";

class imprimirComprobante{

public $idcobros;

public function traerImpresionComprobante(){

date_default_timezone_set("America/Mx");
setlocale(LC_ALL, 'spanish');

//TRAEMOS LA INFORMACIÓN DE LA VENTA

$itemContrata = "idcobros";
$valorContrata = $this->idcobros;

$respuestaContrata = ControladorCobros::ctrMostrarCobrosReporte($itemContrata, $valorContrata);

$urlBase = "https://diplomadosmt.com/sicose_v5/extensiones/tcpdf/pdf/ticket.php?idcobros=";
$urlCompleta = $urlBase . $itemContrata;

$idresponsable = $respuestaContrata[0]['idresponsable'];
$usuario = ControladorUsuarios::ctrMostrarUsuarios('id', $idresponsable);
$nombreCobrador = "";
if(is_array($usuario))
	$nombreCobrador = $usuario['nombre'];

$plantilla = new ControladorPlantilla();
$configuracion = $plantilla -> ctrConfiguracion()[0];
$logo = $configuracion['logo'];
$razon_social = $configuracion['razon_social'];
$prefijo =  $configuracion['prefijo'];
$celular =  $configuracion['celular'];
$email =  $configuracion['email'];
$direccion =  $configuracion['direccion'];
$tasa_cambio =  $configuracion['cambio'];

$codigo = $respuestaContrata[0]["codigoA"];
$codigo2 = $respuestaContrata[0]["codigoR"];
$mpago =  $respuestaContrata[0]["mpago"];
$notitas =  $respuestaContrata[0]["notitas"];
$banco =  $respuestaContrata[0]["banco"];
$fecha_cobro = substr($respuestaContrata[0]["fecha_cobro"],0,-8);


$fecha = substr($respuestaContrata[0]["fecha_servicio"],0,-8);
//$estado = json_decode($respuestaContrata["estado"], true);
$fechaActual = date("Y-m-d H:i:s");
$tipo = $respuestaContrata[0]["tipo"];
$estado = "";

if($respuestaContrata[0]["estado"]==0){
	$estado = "Activo";
}else if($respuestaContrata[0]["estado"] == 1){
	$estado = "Suspendido";
}else {
	$estado = "Finalizado";
}

$codigoComprobante = "";

if($respuestaContrata[0]["codigoR"]!=0){
	$codigoComprobante = "SERIE: R - ".$respuestaContrata[0]["codigoR"];

}else{
	$codigoComprobante = "SERIE: A - ".$respuestaContrata[0]["codigoA"];
}

$nombreCliente = $respuestaContrata[0]["nombres"];
$direccion = $respuestaContrata[0]["direccion"];


//TRAEMOS LA INFORMACIÓN DEL CLIENTE

//$itemCliente = "idpersona";
//$valorCliente = $respuestaContrata["idpersona"];

//$respuestaCliente = ControladorPersonas::ctrMostrarPersonas($itemCliente, $valorCliente);

//TRAEMOS LA INFORMACIÓN DEL VENDEDOR

$itemUsuario = "id";
$valorUsuario = $respuestaContrata[0]["idusuario"];

$respuestaUsuario = ControladorUsuarios::ctrMostrarUsuarios($itemUsuario, $valorUsuario);
$nombreEmpresa = "$razon_social <br>Celular: $prefijo $celular <br> Correo: $email";
//REQUERIMOS LA CLASE TCPDF

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

// ---------------------------------------------------------

$bloque1 = <<<EOF

	<table>

	<tr>

	<td style="width:200px">
	<div>
	<br>
	<img src="../../../$logo" style="width: 140px;">
	</div>
	</td>

	<td style="width:160px">

		<div style="font-size:12px; line-height:15px;">
			<br><br>
		$nombreEmpresa

		</div>

	</td>



	<td style="width:250px; text-align:center; color:red">
		<br><br><br>FOLIO N°.
		<br>$codigo</td>

</tr>

	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ---------------------------------------------------------

$bloque2 = <<<EOF

	<table>

		<tr>

			<td style="width:540px"><img src="images/back.jpg"></td>

		</tr>

	</table>

	<table style="font-size:10px; padding:5px 10px;">

		<tr>

			<td style="border: 1px solid #666; background-color:white; width:390px">

				<b>Alumno:</b> $nombreCliente




			</td>

			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">

				<b>Fecha:</b> $fecha_cobro

			</td>

		</tr>

		<tr>

			<td style="border: 1px solid #666; background-color:white; width:390px"><b>Diplomado:</b> $direccion </td>


			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">

				<b>Estado:</b> $estado

			</td>

		</tr>
		<tr>

			<td style="border: 1px solid #666; background-color:white; width:390px"><b>cobrado por:</b> $nombreCobrador </td>

			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right"><b>Notas del Cobrador:</b> $notitas </td>




		</tr>
		<tr>
		    <td style="border: 1px solid #666; background-color:white; width:170px; text-align:right"><b>Forma de Pago:</b> $mpago </td>
			<td style="border: 1px solid #666; background-color:white; width:170px; text-align:right"><b>Banco Receptor:</b> $banco </td>
			<td style="border: 1px solid #666; background-color:white; width:200px; text-align:right"><b>Banco Referencia Bancaria:</b> $codigo2 </td>
		</tr>

		<tr>

		<td style="border-bottom: 1px solid #666; background-color:white; width:540px"></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');

// ---------------------------------------------------------

$bloque3 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">

		<tr>

		<td style="border: 1px solid #666; background-color:white; width:175px; text-align:center"><b>Descripción del Servicio</b></td>

		<td style="border: 1px solid #666; background-color:white; width:97px; text-align:center"><b>Tipo Servicio</b></td>

		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>Estado Pago</b></td>



		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>Fecha Pago</b></td>

		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>Valor</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// ---------------------------------------------------------
$total = 0;

foreach ($respuestaContrata as $key => $value) {

	$total = number_format($value["total"],2,'.',',');

	$fecha = strtotime($value["fechas_pagos"]);

	$mes  = date("d/m/Y", $fecha);

	$estadoPago = "";

	$valor = number_format($value["valor_servicio"],2,'.',',');

	if($value["estado_pago"] == 0){
		$estadoPago = "PENDIENTE";
		//$valor = "---------";
	}else if($value["estado_pago"] == 1){
		$estadoPago = "PAGADO";
		//$total += $value["valor_servicio"];
	}else if ($value["estado_pago"] == 2){
		$estadoPago = "VENCIDO";
		//$valor = "Q.00.00";
	}

$bloque4 = <<<EOF

 	<table style="font-size:10px; padding:5px 10px;">

 		<tr>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:175px; text-align:center">
 				$value[servicio]
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:97px; text-align:center">
 				$value[descripcion]
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:90px; text-align:center">
 				$estadoPago
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:90px; xt-align:center; text-transform:capitalize;">
 				$mes
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:90px; text-align:center"> $ $total
 			</td>


 		</tr>

 	</table>


EOF;

	$pdf->writeHTML($bloque4, false, false, false, false, '');

}

if ($respuestaContrata[0]["recargo"] ==1){
$bloque5 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">

		<tr>

		<td style="border: 1px solid #666; background-color:white; width:175px; text-align:center"><b>Recargos</b></td>

		<td style="border: 1px solid #666; background-color:white; width:97px; text-align:center"><b></b></td>

		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b></b></td>



		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b></b></td>

		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>5% Inc</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque5, false, false, false, false, '');

}

$bloque6 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">
		<tr>

			<td style=" background-color:white; width:540px"></td>

		</tr>

		<tr>
			<td style=" background-color:white; width:175px; text-align:center"><b></b></td>
			<td style=" background-color:white; width:97px; text-align:center"><b></b></td>
			<td style=" background-color:white; width:90px; text-align:center"><b></b></td>
			<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>Total</b></td>
			<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>$ $total</b></td>
		</tr>
		<tr>
			<td style=" background-color:white; width:175px; text-align:center"><b></b></td>
			<td style=" background-color:white; width:97px; text-align:center"><b></b></td>
			<td style=" background-color:white; width:90px; text-align:center"><b></b></td>
			
		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque6, false, false, false, false, '');


$bloque6 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">
		<tr>

		<td style="border:none; background-color:white; width:540px"></td>

		</tr>

		<tr>

		<td style="border:none; background-color:white; width:175px; text-align:center"><b>Elaborado por:</b> $respuestaUsuario[nombre]</td>

		</tr>
		<tr>

		<td style="border:none; background-color:white; width:175px; text-align:center"><b>Fecha de reimpresion:</b> $fechaActual</td>

		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>



		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>

		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque6, false, false, false, false, '');


// Construir la URL completa con el ID variable
$urlBase = "https://diplomadosmt.com/sicose_v5/extensiones/tcpdf/pdf/ticket.php?idcobros=";
$urlCompleta = $urlBase . $valorContrata;

// Configurar el estilo del código QR
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0, 0, 0),
    'bgcolor' => array(255, 255, 255),
    'module_width' => 1,
    'module_height' => 1
);

// Generar el código QR
$pdf->write2DBarcode($urlCompleta, 'QRCODE,L', 20, $pdf->getY() + 5, 40, 40, $style, 'N');

// Texto debajo del QR
$pdf->SetXY(10, $pdf->getY() + 3);
$pdf->SetFont('helvetica', '', 8);
$pdf->Cell(40, 5, 'Escanea para verificar la autenticidad ', 0, 0, 'C');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO

//$pdf->Output('factura.pdf', 'D');
$pdf->Output('factura.pdf');


//SALIDA DEL ARCHIVO

//$pdf->Output('factura.pdf', 'D');
$pdf->Output('comprobante.pdf');

}

}

$factura = new imprimirComprobante();
$factura -> idcobros = $_GET["idcobros"];
$factura -> traerImpresionComprobante();

?>
